<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Meta_Tag extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/meta_tag_model', 'meta_tag');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['meta_tags'] = $this->meta_tag->get_meta_tag_list();
        $data['page_heading'] = 'Manage Meta Tags';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/meta_tag/meta_tag_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('meta_tag_url', 'Meta Tag Url', 'trim|required');
            $this->form_validation->set_rules('meta_tag_title', 'Meta Tag Title', 'trim|required');
            
            
            if ($this->form_validation->run()) {
                if ($_FILES["meta_tag_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/header_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('meta_tag_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->meta_tag->add_meta_tag($detail['upload_data']['file_name']);
                $this->session->set_flashdata('success_message', 'Product Label Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/meta-tag');
                exit;
            } else {
                $data['meta_tag_url'] = $this->input->post('meta_tag_url');
                $data['meta_tag_title'] = $this->input->post('meta_tag_title');
                $data['meta_tag_keywords'] = $this->input->post('meta_tag_keywords');
                $data['meta_tag_description'] = $this->input->post('meta_tag_description');
                $data['meta_tag_image'] = $this->input->post('meta_tag_image');
            }
        }
        $data['page_heading'] = 'Add Meta Tag';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/meta_tag/meta_tag_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($meta_tag_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('meta_tag_url', 'Meta Tag Url', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["meta_tag_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/header_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('meta_tag_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->meta_tag->update_meta_tag($meta_tag_id, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('success_message', 'Product Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/meta-tag');
                exit;
            } else {
               $data['meta_tag_url'] = $this->input->post('meta_tag_url');
                $data['meta_tag_title'] = $this->input->post('meta_tag_title');
                $data['meta_tag_keywords'] = $this->input->post('meta_tag_keywords');
                $data['meta_tag_description'] = $this->input->post('meta_tag_description');
                $data['meta_tag_image'] = $this->input->post('meta_tag_image');
            }
        } else {
            $meta_tag_detail = $this->meta_tag->get_meta_tag_detail($meta_tag_id);
            $data['meta_tag_title'] = $meta_tag_detail['meta_tag_title'];
            $data['meta_tag_url'] = $meta_tag_detail['meta_tag_url'];
            $data['meta_tag_keywords'] = $meta_tag_detail['meta_tag_keywords'];
            $data['meta_tag_description'] = $meta_tag_detail['meta_tag_description'];
            $data['meta_tag_image'] = $meta_tag_detail['meta_tag_image'];
        }
        $data['page_heading'] = 'Edit Meta Tags';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/meta_tag/meta_tag_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($meta_tag_id, $meta_tag_status) {
        if ($meta_tag_id != '' && $meta_tag_status != '') {
            $this->meta_tag->update_status($meta_tag_id, $meta_tag_status);
            $this->session->set_flashdata('success_message', 'Status Of This Record Has Been Updated Successfully');
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

}
