<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Nav_Menu extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/nav_menu_model', 'menu');       
        $this->load->library('form_validation');
    }

    public function index($grupId) {
        $data['nav_menu_data'] = $this->menu->get_nav_list($grupId);
        $data['breadcumb'] = 'Manage Navigation';
        $data['group_id'] = $grupId;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/nav_menu/nav_menu_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add($grupId) { 
        $data['breadcumb'] = 'Add Navigation';
        if (!empty($_POST)) {
            
              $this->form_validation->set_rules('nav_menu_title', 'Nav Menu Title', 'trim|required');  
              
            if ($this->form_validation->run()) {
                $this->menu->add_nav_menu($grupId);                
                $this->session->set_flashdata('NavigationSuccess', 'Navigation Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/navigation/'.$grupId);
                exit;
            } else {
                $data['nav_menu_title'] = $this->input->post('nav_menu_title');
                $data['nav_menu_url'] = $this->input->post('nav_menu_url');
                $data['nav_menu_position'] = $this->input->post('nav_menu_position');
                $data['nav_menu_nav_grp_fk'] = $this->input->post('nav_menu_nav_grp_fk');
                $data['nav_menu_parent_fk'] = $this->input->post('nav_menu_parent_fk');
                $data['nav_menu_parent'] = $this->input->post('nav_menu_parent');
            }
        }       
        $data['menu_list'] = $this->menu->get_nav_list($grupId);
        $data['group_id'] = $grupId;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/nav_menu/nav_menu_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($grupId,$navMenuId) {

        if (!empty($_POST)) {
            $this->form_validation->set_rules('nav_menu_title', 'Nav Menu Title', 'trim|required');  
            if ($this->form_validation->run()) {
                $this->menu->update_nav_menu($navMenuId);               
                $this->session->set_flashdata('NavigationSuccess', 'Navigation Detail Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/navigation/'.$grupId);
                exit;
            } else {
                $data['nav_menu_title'] = $this->input->post('nav_menu_title');
                $data['nav_menu_url'] = $this->input->post('nav_menu_url');
                $data['nav_menu_position'] = $this->input->post('nav_menu_position');           
                $data['nav_menu_parent_fk'] = $this->input->post('nav_menu_parent_fk');
                $data['nav_menu_parent'] = $this->input->post('nav_menu_parent');
                
            }
        } else {
            $lists = $this->common_model->get_single_row_from_any_table('nav_menu_id',$navMenuId,'tbl_nav_menu');
     
                $data['nav_menu_title'] = $lists->nav_menu_title;
                $data['nav_menu_url'] = $lists->nav_menu_url;
                $data['nav_menu_position'] = $lists->nav_menu_position;            
                $data['nav_menu_parent_fk'] = $lists->nav_menu_parent_fk;
                $data['nav_menu_parent'] = $lists->nav_menu_parent;
           
        }
        $data['breadcumb'] = 'Edit Navigation';       
        $data['menu_list'] = $this->menu->get_nav_list($grupId);
        $data['group_id'] = $grupId;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/nav_menu/nav_menu_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($grupId,$navMenuId, $status) {
        if ($grupId!='' && $navMenuId != '' && $status!='') {
            $this->menu->update_status($navMenuId, $status);
            $this->session->set_flashdata('NavigationSuccess', 'Status Of This Record Has Been Changed Successfully');
            redirect($this->config->item('backend_url') . '/navigation/'.$grupId);
            exit;
        }
    }

}
