<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Package extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/package_model', 'package');
        $this->load->model($this->config->item('backend_folder_name') . '/product_model', 'product');
        $this->load->model($this->config->item('backend_folder_name') . '/category_model', 'category');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['packages_data'] = $this->package->get_packages_list();
        $data['page_heading'] = 'Manage Packages';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/package/package_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('package_name', 'Package Name', 'trim|required');
            $this->form_validation->set_rules('package_price', 'Package Name', 'trim|required');
            $this->form_validation->set_rules('package_min_people', 'Package Minimum Peoples', 'trim|required');
            $this->form_validation->set_rules('package_content', 'Package Content', 'trim|required');
            if ($this->form_validation->run()) {
                $this->package->add_package();
                $this->session->set_flashdata('package_message', 'Package Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/package');
                exit;
            } else {
                $data['package_name'] = $this->input->post('package_name');
                $data['package_price'] = $this->input->post('package_price');
                $data['package_min_people'] = $this->input->post('package_min_people');
                $data['package_content'] = $this->input->post('package_content');
            }
        }
        $data['page_heading'] = 'Add Package';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/package/package_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($package_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('package_name', 'Package Name', 'trim|required');
            $this->form_validation->set_rules('package_price', 'Package Name', 'trim|required');
            $this->form_validation->set_rules('package_min_people', 'Package Minimum Peoples', 'trim|required');
            $this->form_validation->set_rules('package_content', 'Package Content', 'trim|required');
            if ($this->form_validation->run()) {
                $this->package->update_package($package_id);
                $this->session->set_flashdata('package_message', 'Package Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/package');
                exit;
            } else {
                $data['package_name'] = $this->input->post('package_name');
                $data['package_price'] = $this->input->post('package_price');
                $data['package_min_people'] = $this->input->post('package_min_people');
                $data['package_content'] = $this->input->post('package_content');
            }
        } else {
            $package_detail = $this->package->get_package_detail($package_id);
            $data['package_name'] = $package_detail['package_name'];
            $data['package_price'] = $package_detail['package_price'];
            $data['package_min_people'] = $package_detail['package_min_people'];
            $data['package_content'] = $package_detail['package_content'];
        }
        $data['page_heading'] = 'Edit Package';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/package/package_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($package_id, $package_status) {
        if ($package_id != '' && $package_status != '') {
            $this->package->update_status($package_id, $package_status);
            $this->session->set_flashdata('package_message', 'Status Of This Record Has Been Updated Successfully');
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

    public function package_attributes($package_id) {
        $data['package_category_list'] = $this->category->get_category_list(3);
        if (!empty($_POST)) {
           // echo '<pre>';print_r($_POST);die;
            $this->package->delete_package_attributes($package_id);
            $this->package->add_package_attributes($package_id);
            $this->session->set_userdata('package_message', 'Package Attributes Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/package/package-attributes/' . $package_id);
            exit;
        } else {
            $data['page_heading'] = 'Manage Package Attributes';
            $data['package_attribute_list'] = $this->package->get_package_attributes($package_id);
            $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
            $this->load->view($this->config->item('backend_folder_name') . '/package/package_attributes');
            $this->load->view($this->config->item('backend_folder_name') . '/footer');
        }
    }

    public function get_package_products() {
        $category_id = $this->input->post('category_id');
        $data['package_products'] = $package_products = $this->product->get_product_list(3, $category_id);
        $data['success'] = true;
        if (sizeof($package_products) == 0) {
            $data['success'] = false;
        }
        echo json_encode($data);
        die;
    }
public function delete_package_attribute($package_attribute_id) {
        if (isset($package_attribute_id) && $package_attribute_id != '') {
            $data['success']=$this->package->delete_package_attribute($package_attribute_id);
            echo json_encode($data);
        die;
        }
    }
}
