<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Product_Label extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/product_label_model', 'product_label');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['product_labels'] = $this->product_label->get_product_label_list();
        $data['page_heading'] = 'Manage Product Labels';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/product/product_label_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('prd_label_name', 'Product Label Name', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["prd_label_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/product_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('prd_label_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->product_label->add_product_label($detail['upload_data']['file_name']);
                $this->session->set_flashdata('success_message', 'Product Label Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/product-label');
                exit;
            } else {
                $data['prd_label_name'] = $this->input->post('prd_label_name');
            }
        }
        $data['page_heading'] = 'Add Product Label';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/product/product_label_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($product_label_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('prd_label_name', 'Product Label Name', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["prd_label_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/product_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('prd_label_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->product_label->update_product_label($product_label_id, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('success_message', 'Product Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/product-label');
                exit;
            } else {
                $data['prd_label_name'] = $this->input->post('prd_label_name');
            }
        } else {
            $product_label_detail = $this->product_label->get_product_label_detail($product_label_id);
            $data['prd_label_name'] = $product_label_detail['prd_label_name'];
            $data['prd_label_image'] = $product_label_detail['prd_label_image'];
        }
        $data['page_heading'] = 'Edit Product Label';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/product/product_label_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($product_label_id, $product_label_status) {
        if ($product_label_id != '' && $product_label_status != '') {
            $this->product_label->update_status($product_label_id, $product_label_status);
            $this->session->set_flashdata('success_message', 'Status Of This Record Has Been Updated Successfully');
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

}
