<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Testimonial extends CI_Controller {

    public function __construct() {
        parent::__construct();
        //  $this->common_model->check_admin_login_session();
        $this->load->model($this->config->item('backend_folder_name') . '/testimonial_model', 'testimonial');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['testimonial_list'] = $this->testimonial->get_testimonial_list();
        $data['breadcumb'] = 'Manage Testimonial';
        $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('backend_folder_name') . '/testimonial/testimonial_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            if ($_FILES["testimonial_image"]['name'] == '')
                $this->form_validation->set_rules('testimonial_image', 'Testimonial Image', 'trim|required');
            $this->form_validation->set_rules('testimonial_user', 'Testimonial User', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["testimonial_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/testimonial_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('testimonial_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->testimonial->add($detail['upload_data']['file_name']);
                $this->session->set_flashdata('TestimonialSuccess', 'Testimonial Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/testimonial');
                exit;
            } else {
                $data['testimonial_content'] = $this->input->post('testimonial_content');
                $data['testimonial_user'] = $this->input->post('testimonial_user');
                $data['testimonial_user_company'] = $this->input->post('testimonial_user_company');
                $data['testimonial_image'] = $this->input->post('testimonial_image');
            }
        }
        $data['breadcumb'] = 'Add Testimonial';
        $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('backend_folder_name') . '/testimonial/testimonial_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($testimonialId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('testimonial_user', 'Testimonial User', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["testimonial_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/testimonial_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('testimonial_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->testimonial->update($testimonialId, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('TestimonialSuccess', 'Testimonial Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/testimonial');
                exit;
            } else {
                $data['testimonial_content'] = $this->input->post('testimonial_content');
                $data['testimonial_user'] = $this->input->post('testimonial_user');
                $data['testimonial_user_company'] = $this->input->post('testimonial_user_company');
                $data['testimonial_image'] = $this->input->post('testimonial_image');
            }
        } else {
            $lists = $this->common_model->get_single_row_from_any_table('testimonial_id', $testimonialId, $this->testimonial->tableName);
            $data['testimonial_content'] = $lists->testimonial_content;
            $data['testimonial_user'] = $lists->testimonial_user;
            $data['testimonial_user_company'] = $lists->testimonial_user_company;
            $data['testimonial_image'] = $lists->testimonial_image;
        }
        $data['breadcumb'] = 'Edit Testimonial';
        $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('backend_folder_name') . '/testimonial/testimonial_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($testimonialId, $status) {
        if ($testimonialId != '' && $status != '') {
            $this->testimonial->update_status($testimonialId, $status);
            $this->session->set_flashdata('TestimonialSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/testimonial');
            exit;
        }
    }

}
