<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Blog extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('blog_model', 'blog');
        $this->load->library('form_validation');
        $this->load->library('recaptcha');
    }

    public function index() {
        $data['blog_data'] = $this->blog->get_blogs();
        $data['page_heading'] = 'Blog';
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/blog');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

    public function blog_detail($blog_slug) {
        $data['blog_data'] = $blog_data = $this->blog->get_blog_detail($blog_slug);
        if (!empty($_POST)) {
$this->recaptcha->recaptcha_check_answer($_SERVER['REMOTE_ADDR'], $this->input->post('recaptcha_challenge_field'), $this->input->post('recaptcha_response_field'));
            $this->form_validation->set_rules('commenter_name', 'Name', 'trim|required');
            $this->form_validation->set_rules('commenter_email', 'Email', 'trim|required|valid_email');
            $this->form_validation->set_rules('commenter_subject', 'subject', 'trim|required');
            $this->form_validation->set_rules('commenter_phone', 'phone', 'trim|required');
            $this->form_validation->set_rules('commenter_comment', 'Comment', 'trim|required');
            if ($this->form_validation->run() && $this->recaptcha->getIsValid()) {
                $this->blog->create_blog_comment($blog_data['blog_id']);
                $this->session->set_flashdata('CommentSuccessMessage', 'Your Comment Has been successfully posted');
                redirect($_SERVER['HTTP_REFERER']);
                exit;
            }  else if (!$this->recaptcha->getIsValid()) {
                $data['captcha_error'] = "The characters you entered didn't match the word verification. Please try again. ";
                $data['commenter_name'] = $this->input->post('commenter_name');
            $data['commenter_email'] = $this->input->post('commenter_email');
            $data['commenter_phone'] = $this->input->post('commenter_phone');
            $data['commenter_subject'] = $this->input->post('commenter_subject');
            $data['commenter_comment'] = $this->input->post('commenter_comment');
            }
        }
        
        if (sizeof($blog_data) == 0) {
            redirect(site_url('blog'));
            exit;
        }
        $data['recaptcha_html'] = $this->recaptcha->recaptcha_get_html();
        $data['blog_comments'] = $this->blog->get_comments_by_blog($blog_data['blog_id']);
        $data['page_heading'] = $blog_data['blog_name'];
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/blog_detail');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

    public function blogs_by_category($blog_cat_slug) {
        $blog_cat_detail = $this->common_model->get_single_row_from_any_table('blog_cat_slug', $blog_cat_slug, $this->blog->blog_category_table);
        $data['blog_data'] = $this->blog->get_blogs_by_category_id($blog_cat_detail->blog_cat_id);
        $data['page_heading'] = $blog_cat_detail->blog_cat_name;
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/blog');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

    public function blogArchive($add_time) {
        $data['blog_data'] = $this->blog->getBlogArchives($add_time);
        $data['blog_archive'] = $add_time;
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/blog');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

}