<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Category extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('category_model', 'category');
        $this->load->model($this->config->item('shopping_folder_name') . '/cart_model', 'cart');
    }

    public function menu() {
        $data['menu_categories'] = $this->category->get_categories_by_type(1);
        $data['page_heading'] = 'Menu';
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/menu');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

    public function dine_in() {
        $data['menu_categories'] = $this->category->get_categories_by_type(5);
        $data['page_heading'] = 'Dine In';
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/menu');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

    public function online_order() {
        $data['all_categories'] = $this->category->get_categories_by_type(2);
        $data['page_heading'] = 'Online Order';
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/online_order');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }
    
    public function online_order_items($cat_slug) {
        $data['all_categories'] = $this->category->get_categories_by_type(2);
        $data['category_detail'] =$category_detail= $this->category->get_category_detail($cat_slug,FALSE,2);
        $data['category_products'] = $this->category->get_products_by_category($data['category_detail']['cat_id']);
        $data['page_heading'] = 'Online Order';
        $data['METATITLE'] = $category_detail['cat_title'];
        $data['METAKEYWORDS'] = $category_detail['cat_keywords'];
        $data['METADESCRIPTION'] = $category_detail['cat_description'];
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/online_order_items');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }
    
    public function order_by_tray() {
        $data['all_categories'] = $this->category->get_categories_by_type(4);
        $data['page_heading'] = 'Order By Tray';
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/order_by_tray');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }
    
    public function order_by_tray_items($cat_slug) {
        $data['all_categories'] = $this->category->get_categories_by_type(4);
        $data['category_detail'] = $this->category->get_category_detail($cat_slug,FALSE,4);
        $data['category_products'] = $this->category->get_products_by_category($data['category_detail']['cat_id']);
        $data['page_heading'] = 'Order By Tray';
        $data['METATITLE'] = $category_detail['cat_title'];
        $data['METAKEYWORDS'] = $category_detail['cat_keywords'];
        $data['METADESCRIPTION'] = $category_detail['cat_description'];
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/order_by_tray_items');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

}