<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Locations extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->model('users_model', 'user');
        $this->load->model('mailsending_model', 'sendingEmail');
        $this->load->model('locations_model', 'locations');
        $this->load->model($this->config->item('shopping_folder_name') . '/cart_model', 'cart');
    }

    public function locations_list() {
        $data['locations_list'] = $this->locations->get_locations_list();
        $data['page_heading'] = 'Our Locations';
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/location');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

    public function location_detail($loc_slug = 'brampton') {
        $data['location_detail'] = $this->locations->get_location_detail($location_data['loc_id']);
        $data['location_data'] = $location_data = $this->locations->get_location_detail($loc_slug);
        if (empty($location_data)) {
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
        
        if (!empty($_POST)) {
                $this->form_validation->set_rules('g-recaptcha-response', 'Recaptcha validation', 'required|callback_validate_captcha');
                $this->form_validation->set_rules('name', 'Name', 'trim|required');
                $this->form_validation->set_rules('email', 'Email Id', 'trim|required|valid_email');
                $this->form_validation->set_rules('phone', 'Phone No', 'trim|required');
                $this->form_validation->set_rules('service_type', 'Service Type', 'trim|required');
                if ($this->form_validation->run()) {
                    $this->user->create_new_user('inquiry');
                    $this->sendingEmail->global_mail(8);
                    $this->session->set_userdata('success_message', 'Thanks for your query/Feedback. Our team will get back to you within 24 hours.');
                    redirect(site_url('location'));
                    exit();
                } else {
                    $data['name'] = $this->input->post('name');
                    $data['email'] = $this->input->post('email');
                    $data['phone'] = $this->input->post('phone');
                    $data['service_type'] = $this->input->post('service_type');
                    $data['comment'] = $this->input->post('comment');
                    $this->session->set_userdata('error_message', 'There Is Some Error');
                }
        } else {
            $data['name'] = '';
            $data['email'] = '';
            $data['phone'] = '';
            $data['service_type'] = '';
            $data['comment'] = '';
        }
        
        $data['location_gallery'] = $this->locations->get_location_gallery($location_data['loc_id']);
        $data['page_heading'] = $location_data['loc_name'];
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/location_detail');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

    public function location_gallery($loc_slug) {
        $data['location_data'] = $location_data = $this->locations->get_location_detail($loc_slug);
        if (empty($location_data)) {
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
        $data['location_gallery'] = $this->locations->get_location_gallery($location_data['loc_id']);
        $data['page_heading'] = $location_data['loc_name'].' Gallery';
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/location_gallery');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

    public function select_user_location() {
        //echo $this->config->item('website_location_selector');die;
        $data['location_data'] = $location_data = $this->locations->get_location_detail('brampton');
        if ($this->config->item('website_location_selector') == 'yes') {
            $data['locations_list'] = $this->locations->get_locations_list();
            $data['page_heading'] = 'Select Your Location';
            $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
            $this->load->view($this->config->item('frontend_folder_name') . '/location_landing', $data);
            $this->load->view($this->config->item('frontend_folder_name') . '/footer');
        } else {
            //echo $location_data['loc_name'];
            $this->session->set_userdata('user_location_id', $this->config->item('website_default_location'));
            $this->session->set_userdata('user_location_name', $location_data['loc_name']);
            //$this->update_cart_by_location($this->config->item('website_default_location'));
            //print_r($this->session->all_userdata());
            redirect(site_url());
            exit;
        }
    }

    public function set_user_location($loc_slug) {
        
        $data['location_detail'] = $location_data = $this->locations->get_location_detail($loc_slug);
       // print_r($location_data);die;
        if (empty($location_data)) {
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
        $this->session->set_userdata('user_location_id', $location_data['loc_id']);
        $this->session->set_userdata('user_location_name', $location_data['loc_name']);
      //  $this->update_cart_by_location($location_id);
        redirect($_GET['redirect']);
        exit;
    }

    public function update_cart_by_location($location_id = '') {
        $province_data = $this->province->getProvinceById($location_id);
        $sub_total = $this->cart_items->getCartItemsTotal();
        $sub_total = $sub_total['total_item_price'];
        $cart_data = $this->cart->getCartDetail();
        if ($cart_data) {
            $discount = $cart_data['discount'];
            $coupon_id = $cart_data['coupon_id'];
            $coupon_code = $cart_data['coupon_code'];
            $coupon_percentage = $cart_data['coupon_percentage'];
            $discounted_total = $sub_total - $discount;
            $gst = number_format((($discounted_total * $province_data->loc_gst) / 100), 2, '.', '');
            $pst = number_format((($discounted_total * $province_data->loc_pst) / 100), 2, '.', '');
            $hst = number_format((($discounted_total * $province_data->loc_hst) / 100), 2, '.', '');
            $total_cart_price = number_format(($discounted_total + $gst + $pst + $hst), 2, '.', '');
            $data = array(
                'cart_id' => $cart_data['cart_id'],
                'sub_total' => $sub_total,
                'location_id' => $province_data->loc_id,
                'location_name' => $province_data->loc_name,
                'gst_per' => $province_data->loc_gst,
                'pst_per' => $province_data->loc_pst,
                'hst_per' => $province_data->loc_hst,
                'discount' => $discount,
                'coupon_id' => $coupon_id,
                'coupon_code' => $coupon_code,
                'coupon_percentage' => $coupon_percentage,
                'gst' => $gst,
                'pst' => $pst,
                'hst' => $hst,
                'total_cart_price' => $total_cart_price,
            );
            $this->cart->updateCart($data);
        }
    }
    
    function validate_captcha() {
        $recaptcha = trim($this->input->post('g-recaptcha-response'));
        $userIp= $this->input->ip_address();
        $secret='6Lc5w84UAAAAAChCsSrVNMjN0V-4wd-_VIcnJjzd';
        $data = array(
            'secret' => "$secret",
            'response' => "$recaptcha",
            'remoteip' =>"$userIp"
        );

        $verify = curl_init();
        curl_setopt($verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
        curl_setopt($verify, CURLOPT_POST, true);
        curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($verify);
        $status= json_decode($response, true);
        //print_r($status);die;
        if(empty($status['success'])){
            $this->form_validation->set_message('validate_captcha', 'Please confirm you are not a robot');
            return FALSE;
        }else{
            return TRUE;
        }
    }

}
