<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Order extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('shopping_folder_name') . '/cart_model', 'cart');
        $this->load->model($this->config->item('shopping_folder_name') . '/order_model', 'order');
        $this->load->model('locations_model', 'locations');
        if ($this->uri->segment(1) == 'order-complete') {
            $this->update_cart_price();
        }
        $this->load->library('Paypal_Lib');
    }

    public function process_order() {
        $cart_data = $this->cart->get_cart_detail();
        
        //print_R($cart_data); exit;
        
        $cart_products_data = $this->cart->get_cart_products();
        if (empty($cart_data)) {
            redirect('cart');
            exit;
        }
        if ($cart_data && $cart_products_data) {
            unset($cart_data['cart_id']);
            $order_id = $this->order->process_order($cart_data);
            foreach ($cart_products_data as $cart_product) {
                $cart_prd_id = $cart_product['cart_prd_id'];
                unset($cart_product['cart_prd_sess_id']);
                unset($cart_product['cart_prd_id']);
                $order_product_id = $this->order->process_order_products($order_id, $cart_product);
                if ($cart_product['cart_prd_type'] == 'package') {
                    $cart_package_products_data = $this->cart->get_cart_package_products($cart_prd_id);
//                    echo '<pre>';
//                    print_r($cart_package_products_data);die;
                    foreach ($cart_package_products_data as $cart_package_product) {
                        unset($cart_package_product['cart_pkg_sess_id']);
                        unset($cart_package_product['cart_pkg_id']);
                        unset($cart_package_product['cart_pkg_cart_prd_fk']);
                        $this->order->process_order_package_products($order_product_id, $cart_package_product);
                    }
                }
            }
            
            $this->cart->delete_cart();
            $this->cart->delete_cart_product();
            $this->cart->delete_cart_package_product();
            $this->session->set_userdata('processing_order_id', $order_id);
            if ($cart_data['cart_pay_type'] == 'cod') {
                redirect('thanks-for-your-order');
                exit();
            } else if ($cart_data['cart_pay_type'] == 'paypal') {
                //$this->paypal_lib->paypal_url = 'https://www.sandbox.paypal.com/cgi- bin/webscr'; // testing paypal url
                //$this->paypal_lib->add_field('business', 'sumit12690-facilitator-us@gmail.com');
                //akm.nam7189-buyer@gmail.com
                $this->paypal_lib->paypal_url = 'https://www.paypal.com/cgi-bin/webscr'; // paypal url
                $this->paypal_lib->add_field('business', $this->config->item('website_paypal_email'));
                $this->paypal_lib->add_field('currency_code', 'CAD');
                //$this->paypal_class->add_field('business', $this->config->item('bussinessPayPalAccount'));
                $this->paypal_lib->add_field('return', site_url('payment-success')); // return url
                $this->paypal_lib->add_field('cancel_return', site_url('payment-failure')); // cancel url
                $this->paypal_lib->add_field('notify_url', site_url('validate-paypal')); // notify url
                //$totalPrice = $this->session->userdata('totalPrice');
                $this->paypal_lib->add_field('item_name', 'Gurukitchen Order Id-' . $order_id);
                $this->paypal_lib->add_field('amount', $cart_data['cart_total']);
                $this->paypal_lib->add_field('custom', $this->session->userdata('processing_order_id'));
                redirect($this->paypal_lib->paypal_get_request_link());  // submit the fields to paypal
                //$p->dump_fields(); // for debugging, output a table of all the fields
                exit;
            }
        } else {
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

    public function track_order($order_id, $order_sess_id) {
        $data['order_data'] = $order_detail = $this->order->get_order_detail($order_id);
        if ($order_detail) {
            $data['order_products'] = $this->order->get_order_products($order_id);
            $data['page_heading'] = 'Track your order';
            $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
            $this->load->view($this->config->item('shopping_folder_name') . '/order_track');
            $this->load->view($this->config->item('frontend_folder_name') . '/footer');
        } else {
            redirect(site_url());
            exit;
        }
    }

    public function update_cart_price($tax_location = FALSE) {
        if (!$tax_location) {
            if ($this->session->userdata('user_location_id'))
                $tax_location = $this->session->userdata('user_location_id');
            else
                $tax_location = $this->config->item('website_default_location');
        }
        $cart_products_total = $this->cart->get_cart_products_total();
        $cart_products_total = $cart_products_total['cart_prd_tot_price'];
        if (!$cart_products_total) {
            $this->cart->delete_cart();
            $this->cart->delete_cart_product();
            $this->cart->delete_cart_package_product();
            redirect(site_url());
            exit;
        }
        $cart_data = $this->cart->get_cart_detail();
        $cart_id = ($cart_data['cart_id']) ? $cart_data['cart_id'] : FALSE;
        /* -----------------------------Coupon Start -------------------------------- */
        $cart_cpn_discount = 0;
        $cart_cpn_id = 0;
        $cart_cpn_code = '';
        $cart_cpn_per = 0;
        if ($cart_data) {
            if ($cart_data['cart_cpn_per'])
                $cart_cpn_discount = (($cart_products_total * $cart_data['cart_cpn_per']) / 100);
            else
                $cart_cpn_discount = $cart_data['cart_cpn_discount'];
            $cart_cpn_id = $cart_data['cart_cpn_id'];
            $cart_cpn_code = $cart_data['cart_cpn_code'];
            $cart_cpn_per = $cart_data['cart_cpn_per'];
        }
        /* ------------------------Coupon End-------------------------- */
        /* ----------------------Delivery Charges Start------------------------------- */
        $cart_del_charges = 0;
        $cart_del_loc_id = 0;
        $cart_del_loc_name = '';
        if ($cart_data) {
            $cart_del_charges = $cart_data['cart_del_charges'];
            $cart_del_loc_id = $cart_data['cart_del_loc_fk'];
            $cart_del_loc_name = $cart_data['cart_del_loc_name'];
        }
        if ($cart_data['cart_type'] == 'pickup') {
            $cart_del_charges = 0;
        } else if ($cart_data['cart_type'] == 'delivery') {
            $delivery_location_detail = $this->locations->get_location_detail(FALSE, $cart_data['cart_del_loc_fk'], FALSE);
            if ($delivery_location_detail) {
                if ($delivery_location_detail['loc_min_order'] > $cart_products_total) {
                    $this->session->set_userdata('cart_error_message', 'Your order value should be greater than $' . $delivery_location_detail['loc_min_order'] . ' For Delivery In ' . $delivery_location_detail['loc_name'] . '.');
                    redirect(site_url('cart'));
                    exit;
                }
                $cart_del_charges = $delivery_location_detail['loc_del_charges'];
            }
        }
        /* ------------------------Delivery Charges end-------------------------- */
        /* ----------------------Cart Tax Calculations------------------------------- */
        $gst_per = 0;
        $pst_per = 0;
        $hst_per = 0;
        $cart_ord_loc_id = 0;
        $cart_ord_loc_name = '';
        $tax_location_detail = $this->locations->get_location_detail(FALSE, $tax_location, FALSE);
        if ($tax_location_detail) {
            $gst_per = $tax_location_detail['loc_gst'];
            $pst_per = $tax_location_detail['loc_pst'];
            $hst_per = $tax_location_detail['loc_hst'];
            $cart_ord_loc_name = $tax_location_detail['loc_name'];
            $cart_ord_loc_id = $tax_location;
        }

        /* ------------------------Cart Tax Calculations End-------------------------- */
        $cart_discounted_total = $cart_products_total - $cart_cpn_discount;
        $cart_gst = number_format((($cart_discounted_total * $gst_per) / 100), 2, '.', '');
        $cart_pst = number_format((($cart_discounted_total * $pst_per) / 100), 2, '.', '');
        $cart_hst = number_format((($cart_discounted_total * $hst_per) / 100), 2, '.', '');
        $cart_total = number_format(($cart_discounted_total + $cart_del_charges + $cart_gst + $cart_pst + $cart_hst), 2, '.', '');
        $cart_data = array(
            'cart_sess_id' => $this->session->userdata('session_id'),
            'cart_prd_total' => $cart_products_total,
            'cart_cpn_per' => $cart_cpn_per,
            'cart_cpn_fk' => $cart_cpn_id,
            'cart_cpn_code' => $cart_cpn_code,
            'cart_cpn_discount' => $cart_cpn_discount,
            'cart_del_charges' => $cart_del_charges,
            'cart_ord_loc_name' => $cart_ord_loc_name,
            'cart_ord_loc_fk' => $cart_ord_loc_id,
            'cart_del_loc_name' => $cart_del_loc_name,
            'cart_del_loc_fk' => $cart_del_loc_id,
            'cart_gst' => $cart_gst,
            'cart_pst' => $cart_pst,
            'cart_hst' => $cart_hst,
            'cart_gst_per' => $gst_per,
            'cart_pst_per' => $pst_per,
            'cart_hst_per' => $hst_per,
            'cart_total' => $cart_total,
        );
        $this->cart->update_cart($cart_data, $cart_id);
    }

}
