<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Thanks extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('shopping_folder_name') . '/order_model', 'order');
        $this->load->model('mailsending_model', 'mailer');
        $this->load->library('Paypal_Lib');
    }

    public function index() {
        if ($this->session->userdata('processing_order_id')) {
            $data['order_id'] = $order_id = $this->session->userdata('processing_order_id');
            $this->session->unset_userdata('processing_order_id');
            $data['order_data'] = $order_detail = $this->order->get_order_detail($order_id);
            $data['order_products'] = $this->order->get_order_products($order_id);
            $data['page_heading'] = 'Thanks for your order';
            $this->mailer->order_mail($order_id);
            $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
            $this->load->view($this->config->item('shopping_folder_name') . '/thanks');
            $this->load->view($this->config->item('frontend_folder_name') . '/footer');
        } else {
            redirect('cart');
            exit;
        }
    }

    public function paypal_failure() {
        $order_id = $this->session->userdata('processing_order_id');
        $payment_data = array(
            'order_payment_status' => 'unpaid',
            'order_status' => 'cancelled',
            'order_other_data' => json_encode($_REQUEST),
        );
        $this->order->process_order($payment_data, $order_id);
        redirect('thanks-for-your-order');
        exit();
    }

    public function paypal_success() {
        $order_id = $this->session->userdata('processing_order_id');
        $payment_data = array(
            'order_payment_status' => 'paid',
            'order_status' => 'pending',
            'order_transaction_id' => $_REQUEST['txn_id'],
            'order_other_data' => json_encode($_REQUEST),
        );
        $this->order->process_order($payment_data, $order_id);
        redirect('thanks-for-your-order');
        exit();
    }

    public function validatePaypal() {
        // $this->paypal->paypal_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr&#8217'; // testing paypal url
        $this->paypal_lib->paypal_url = 'https://www.paypal.com/cgi-bin/webscr&#8217;'; // paypal url
        if ($this->paypal_lib->validate_ipn()) {
            $order_id = trim($_POST['custom']);
            $itemName = trim($_POST['item_name']);
        }
    }

}
