<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Banner_Model extends CI_Model {

    var $banner_table = 'tbl_banner';
    var $banner_types_table = 'tbl_banner_types';

    function get_banner_list($banner_type_id) {
        $this->db->select($this->banner_table . '.*');
        $this->db->select($this->banner_types_table . '.bnr_type_name');
        $this->db->where($this->banner_table . '.bnr_status !=', 'deleted');
        $this->db->where($this->banner_table . '.bnr_type_fk', $banner_type_id);
        $this->db->join($this->banner_types_table, $this->banner_table . '.bnr_type_fk=' . $this->banner_types_table . '.bnr_type_id');
        $query = $this->db->get($this->banner_table);
        $result = $query->result_array();
        return $result;
    }

    function get_max_order_number() {
        $this->db->select_max('bnr_order');
        $this->db->from($this->banner_table);
        $query = $this->db->get();
        $result = $query->row_array();
        return $result;
    }

    function add($type_id, $banner_image) {
        if ($banner_image)
            $this->db->set('bnr_image', $banner_image);
        $max_order_no = $this->get_max_order_number();
        $max_order_no = $max_order_no['bnr_order'] + 1;
        $this->db->set('bnr_order', $max_order_no);
        $this->db->set('bnr_type_fk', $type_id);
        $this->db->set('bnr_title', $this->input->post('bnr_title'));
        $this->db->set('bnr_link', $this->input->post('bnr_link'));
        $this->db->set('bnr_text', $this->input->post('bnr_text'));
        $this->db->set('bnr_status', 'active');
        $query = $this->db->insert($this->banner_table);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($bannerId, $banner_image) {
        if ($banner_image)
            $this->db->set('bnr_image', $banner_image);
        $this->db->set('bnr_title', $this->input->post('bnr_title'));
        $this->db->set('bnr_link', $this->input->post('bnr_link'));
        $this->db->set('bnr_text', $this->input->post('bnr_text'));
        $this->db->where('bnr_id', $bannerId);
        $query = $this->db->update($this->banner_table);
        return $response;
    }

    public function update_status($bannerId, $status) {
        $this->db->set('bnr_status', $status);
        $this->db->where('bnr_id', $bannerId);
        $response = $this->db->update($this->banner_table);
        return $response;
    }

}
