<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Blog_Category_Model extends CI_Model {

    var $tableName = 'tbl_blog_category';

    function get_blog_category_list() {
        $this->db->where($this->tableName . '.blog_cat_status !=', 'deleted');      
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function add() {

        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('blog_cat_name'), 'tbl_blog_category', 'blog_cat_slug');
        $this->db->set('blog_cat_slug', $slug);

        $this->db->set('blog_cat_name', $this->input->post('blog_cat_name'));
        $this->db->set('blog_cat_title', $this->input->post('blog_cat_title'));
        $this->db->set('blog_cat_keywords', $this->input->post('blog_cat_keywords'));
        $this->db->set('blog_cat_description', $this->input->post('blog_cat_description'));


        $this->db->set('blog_cat_status', 'active');

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($catId) {
        $this->db->set('blog_cat_name', $this->input->post('blog_cat_name'));
        $this->db->set('blog_cat_title', $this->input->post('blog_cat_title'));
        $this->db->set('blog_cat_keywords', $this->input->post('blog_cat_keywords'));
        $this->db->set('blog_cat_description', $this->input->post('blog_cat_description'));

        $this->db->where('blog_cat_id', $catId);
        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function update_status($catId, $status) {
        $this->db->set('blog_cat_status', $status);
        $this->db->where('blog_cat_id', $catId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

}
