<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Blog_Model extends CI_Model {
    var $blog_table = 'tbl_blog';

     function get_blog_list() {
        $this->db->where($this->blog_table . '.blog_status !=', 'deleted');       
        $query = $this->db->get($this->blog_table);
        $result = $query->result_array();
        return $result;
    }   

    function add_blog($blog_image) {
        if ($blog_image)
            $this->db->set('blog_image', $blog_image);
        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('blog_name'), $this->blog_table,'blog_slug');
        $this->db->set('blog_slug', $slug);
        $this->db->set('blog_cat_fk', $this->input->post('blog_cat_fk'));
        $this->db->set('blog_name', $this->input->post('blog_name'));
        $this->db->set('blog_content', $this->input->post('blog_content'));
        $this->db->set('blog_title', $this->input->post('blog_title'));
        $this->db->set('blog_keywords', $this->input->post('blog_keywords'));
        $this->db->set('blog_description', $this->input->post('blog_description'));     
        $this->db->set('blog_blogger_name', $this->input->post('blog_blogger_name'));   
        $this->db->set('blog_show_image', $this->input->post('blog_show_image'));
        $this->db->set('blog_time', time());       
        $this->db->set('blog_status', 'active');
        $query = $this->db->insert($this->blog_table);
        $response = $this->db->insert_id();
        return $this->db->insert_id();
    }

    function update_blog($blogId, $blog_image) {
        if ($blog_image)
            $this->db->set('blog_image', $blog_image);
        $this->db->set('blog_cat_fk', $this->input->post('blog_cat_fk'));
        $this->db->set('blog_name', $this->input->post('blog_name'));
        $this->db->set('blog_content', $this->input->post('blog_content'));
        $this->db->set('blog_title', $this->input->post('blog_title'));
        $this->db->set('blog_keywords', $this->input->post('blog_keywords'));
        $this->db->set('blog_description', $this->input->post('blog_description'));     
        $this->db->set('blog_blogger_name', $this->input->post('blog_blogger_name'));  
        $this->db->set('blog_show_image', $this->input->post('blog_show_image'));
        $this->db->where('blog_id', $blogId);
        $query = $this->db->update($this->blog_table);
        return $response;
    }
    
    public function update_status($blogId, $action) {
        $this->db->set('blog_status', $action);
        $this->db->where('blog_id', $blogId);
        $response = $this->db->update($this->blog_table);
        return $response;
    }

}
