<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Coupon_Model extends CI_Model {

    var $coupon_table = 'tbl_coupons';

    function get_coupons_list() {
        $this->db->where($this->coupon_table . '.cpn_status !=', 'deleted');
        $query = $this->db->get($this->coupon_table);
        $result = $query->result_array();
        return $result;
    }

    function get_coupon_detail($coupon_id) {
        $this->db->where($this->coupon_table . '.cpn_id', $coupon_id);
        $this->db->where($this->coupon_table . '.cpn_status !=', 'deleted');
        $query = $this->db->get($this->coupon_table);
        $result = $query->row_array();
        return $result;
    }

    function add_coupon() {
        $this->db->set('cpn_code', $this->input->post('cpn_code'));
        $this->db->set('cpn_discount', $this->input->post('cpn_discount'));
        $this->db->set('cpn_min_price', $this->input->post('cpn_min_price'));
        $this->db->set('cpn_type', $this->input->post('cpn_type'));
        $this->db->set('cpn_loc_fk', $this->input->post('location_id'));
        $this->db->set('cpn_exp_date', strtotime($this->input->post('cpn_exp_date')));
        $this->db->set('cpn_status', 'active');
        return $this->db->insert($this->coupon_table);
    }

    function update_coupon($coupon_id) {
        $this->db->set('cpn_code', $this->input->post('cpn_code'));
        $this->db->set('cpn_discount', $this->input->post('cpn_discount'));
        $this->db->set('cpn_min_price', $this->input->post('cpn_min_price'));
        $this->db->set('cpn_type', $this->input->post('cpn_type'));
        $this->db->set('cpn_loc_fk', $this->input->post('location_id'));
        $this->db->set('cpn_exp_date', strtotime($this->input->post('cpn_exp_date')));
        $this->db->set('cpn_status', 'active');
        $this->db->where('cpn_id', $coupon_id);
        return $this->db->update($this->coupon_table);
    }

    public function update_status($coupon_id, $coupon_status) {
        $this->db->set('cpn_status', $coupon_status);
        $this->db->where('cpn_id', $coupon_id);
        return $this->db->update($this->coupon_table);
    }

}
