<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Email_Templates_Model extends CI_Model {

    var $email_template_table = 'tbl_email_template';

    function get_templates_list() {
        $this->db->where('et_status !=', 'deleted');
        $query = $this->db->get($this->email_template_table);
        $result = $query->result_array();
        return $result;
    }

    function get_template_detail($template_id) {
        $this->db->where('et_status !=', 'deleted');
        $this->db->where('et_id', $template_id);
        $query = $this->db->get($this->email_template_table);
        $result = $query->row_array();
        return $result;
    }

    function update_email_template($template_id) {
        $this->db->set('et_sender_name', $this->input->post('sender_name'));
        $this->db->set('et_sender_email', $this->input->post('sender_email'));
        $this->db->set('et_cc_emails', $this->input->post('cc_emails'));
        $this->db->set('et_subject', $this->input->post('subject'));
        $this->db->set('et_content', $this->input->post('content'));
        $this->db->where('et_id', $template_id);
        $query = $this->db->update($this->email_template_table);
        return $response;
    }

    public function update_status($template_id, $template_status) {
        $this->db->set('et_status', $template_status);
        $this->db->where('et_id', $template_id);
        $response = $this->db->update($this->email_template_table);
        return $response;
    }

}
