<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Location_Model extends CI_Model {

    var $locations_table = 'tbl_locations';
    var $locations_type_table = 'tbl_location_type';
    var $locations_images_table = 'tbl_location_images';

    function get_location_list($location_type_id) {
        $this->db->where($this->locations_table . '.loc_status !=', 'deleted');
        $this->db->join($this->locations_type_table, $this->locations_table . '.loc_type_fk=' . $this->locations_type_table . '.loc_type_id');
        $this->db->where($this->locations_table . '.loc_type_fk', $location_type_id);
        $query = $this->db->get($this->locations_table);
        $result = $query->result_array();
        return $result;
    }

    function get_location_counts() {
         $this->db->where($this->locations_table . '.loc_status !=', 'deleted');
        $query = $this->db->get($this->locations_table);
        $result = $query->num_rows();
        return $result;
    }

    function get_location_detail($location_id) {
        $this->db->where($this->locations_table . '.loc_status !=', 'deleted');
        $this->db->where($this->locations_table . '.loc_id', $location_id);
        $this->db->join($this->locations_type_table, $this->locations_table . '.loc_type_fk=' . $this->locations_type_table . '.loc_type_id');
        $query = $this->db->get($this->locations_table);
        $result = $query->row_array();
        return $result;
    }

    function get_location_parent_list($location_type_id) {
        $this->db->where($this->locations_type_table . '.loc_type_id', $location_type_id);
        $this->db->join($this->locations_table, $this->locations_table . '.loc_type_fk=' . $this->locations_type_table . '.loc_type_parent_fk');
        $this->db->where($this->locations_table . '.loc_status', 'active');
        $query = $this->db->get($this->locations_type_table);
        $result = $query->result_array();
        return $result;
    }

    function add_location($location_type_id) {
        $this->db->set('loc_type_fk', $location_type_id);
        if ($this->input->post('loc_parent_fk')) {
            $this->db->set('loc_parent_fk', $this->input->post('loc_parent_fk'));
        }
        $this->db->set('loc_name', $this->input->post('loc_name'));
        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('loc_name'), $this->locations_table, 'loc_slug');
        $this->db->set('loc_slug', $slug);
        $this->db->set('loc_status', 'active');
        $query = $this->db->insert($this->locations_table);
        $response = $this->db->insert_id();
        return $this->db->insert_id();
    }

    function update_location($location_id) {
        if ($this->input->post('loc_parent_fk')) {
            $this->db->set('loc_parent_fk', $this->input->post('loc_parent_fk'));
        }
        $this->db->set('loc_name', $this->input->post('loc_name'));
        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('loc_name'), $this->locations_table, 'loc_slug');
        $this->db->set('loc_slug', $slug);
        $this->db->where('loc_id', $location_id);
        $query = $this->db->update($this->locations_table);
        return $response;
    }

    function add_location_detail($location_id) {
        //$this->db->set('loc_content', $this->input->post('loc_content'));
        $this->db->set('loc_iframe_code', $this->input->post('loc_iframe_code'));
        $this->db->set('loc_del_line', $this->input->post('loc_del_line'));
        $this->db->set('loc_min_order_line', $this->input->post('loc_min_order_line'));
        $this->db->set('loc_email', $this->input->post('loc_email'));
        $this->db->set('loc_phone', $this->input->post('loc_phone'));
        $this->db->set('loc_hours', $this->input->post('loc_hours'));
        $this->db->set('loc_del_charges', $this->input->post('loc_del_charges'));
        $this->db->set('loc_min_order', $this->input->post('loc_min_order'));
        $this->db->set('loc_address', $this->input->post('loc_address'));
        $this->db->set('loc_gst', $this->input->post('loc_gst'));
        $this->db->set('loc_pst', $this->input->post('loc_pst'));
        $this->db->set('loc_hst', $this->input->post('loc_hst'));
        $this->db->where('loc_id', $location_id);
        $response = $this->db->update($this->locations_table);
        return $response;
    }

    public function update_status($location_id, $location_status) {
        $this->db->set('loc_status', $location_status);
        $this->db->where('loc_id', $location_id);
        $response = $this->db->update($this->locations_table);
        return $response;
    }

    function add_location_image($location_id, $location_img) {
        if ($location_img)
            $this->db->set('loc_img_name', $location_img);
        $this->db->set('loc_img_loc_fk', $location_id);
        $this->db->set('loc_img_default', $this->input->post('loc_img_default'));
        $this->db->set('loc_img_alt_tag', $this->input->post('loc_img_alt_tag'));
        $query = $this->db->insert($this->locations_images_table);
        $response = $this->db->insert_id();
        return $response;
    }

    public function update_image_status($location_imgage_id, $location_imgage_status) {
        $this->db->set('loc_img_status', $location_imgage_status);
        $this->db->where('loc_img_id', $location_imgage_id);
        $response = $this->db->update($this->locations_images_table);
        return $response;
    }

    function get_location_images($location_id) {
        $this->db->where($this->locations_images_table . '.loc_img_status !=', 'deleted');
        $this->db->where('loc_img_loc_fk', $location_id);
        $query = $this->db->get($this->locations_images_table);
        $result = $query->result_array();
        return $result;
    }

    public function set_default_image($location_imgage_id, $location_imgage_status) {
        $this->db->set('loc_img_default', $location_imgage_status);
        $this->db->where('loc_img_id', $location_imgage_id);
        $response = $this->db->update($this->locations_images_table);
        return $response;
    }

    function unset_default_image($location_id) {
        $this->db->set('loc_img_default', 'no');
        $this->db->where('loc_img_loc_fk', $location_id);
        $query = $this->db->update($this->locations_images_table);
        return $response;
    }

}
