<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Order_Model extends CI_Model {

    var $order_table = 'tbl_order';
    var $order_products_table = 'tbl_order_products';
    var $order_pkg_products_table = 'tbl_order_pkg_products';

    function get_order_list() {
        $this->db->where($this->order_table . '.order_status !=', 'deleted');
        $query = $this->db->get($this->order_table);
        $result = $query->result_array();
        return $result;
    }

    function get_order_detail($order_id) {
        $this->db->where($this->order_table . '.order_id', $order_id);
        $this->db->where($this->order_table . '.order_status !=', 'deleted');
        $query = $this->db->get($this->order_table);
        $result = $query->row_array();
        return $result;
    }
    function get_order_counts() {
        $this->db->where($this->order_table . '.order_status', 'pending');
        $query = $this->db->get($this->order_table);
        $result = $query->num_rows();
        return $result;
    }
function get_order_products($order_id) {
        $this->db->where('order_prd_order_fk', $order_id);
        $query = $this->db->get($this->order_products_table);
        $result = $query->result_array();
        return $result;
    }

    function get_order_package_products($order_product_id) {
        $this->db->where('order_pkg_order_prd_fk', $order_product_id);
        $query = $this->db->get($this->order_pkg_products_table);
        $result = $query->result_array();
        return $result;
    }
    public function update_status($order_id, $order_status) {
        $this->db->set('order_status', $order_status);
        $this->db->where('order_id', $order_id);
        return $this->db->update($this->order_table);
    }
     public function update_tracking_message($order_id) {
        $this->db->set('order_tracking_message', $this->input->post('tracking_message'));
        $this->db->where('order_id', $order_id);
        return $this->db->update($this->order_table);
    }
}