<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Package_Model extends CI_Model {

    var $packages_table = 'tbl_packages';
    var $package_attributes_table = 'tbl_package_attributes';

    function get_packages_list() {
        $this->db->where($this->packages_table . '.package_status !=', 'deleted');
        $query = $this->db->get($this->packages_table);
        $result = $query->result_array();
        return $result;
    }
function get_package_detail($package_id) {
        $this->db->where($this->packages_table . '.package_id',$package_id);
        $this->db->where($this->packages_table . '.package_status !=', 'deleted');
        $query = $this->db->get($this->packages_table);
        $result = $query->row_array();
        return $result;
    }
    function add_package() {
        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('package_name'), $this->packages_table, 'package_slug');
        $this->db->set('package_slug', $slug);
        $this->db->set('package_name', $this->input->post('package_name'));
        $this->db->set('package_price', $this->input->post('package_price'));
        $this->db->set('package_min_people', $this->input->post('package_min_people'));
        $this->db->set('package_content', $this->input->post('package_content'));
        $this->db->set('package_status', 'active');
        $query = $this->db->insert($this->packages_table);
        return $this->db->insert_id();
    }

    function update_package($package_id) {
        $this->db->set('package_name', $this->input->post('package_name'));
        $this->db->set('package_price', $this->input->post('package_price'));
        $this->db->set('package_min_people', $this->input->post('package_min_people'));
        $this->db->set('package_content', $this->input->post('package_content'));
        $this->db->where('package_id', $package_id);
        $response = $this->db->update($this->packages_table);
        return $response;
    }

    public function update_status($package_id, $package_status) {
        $this->db->set('package_status', $package_status);
        $this->db->where('package_id', $package_id);
        $response = $this->db->update($this->packages_table);
        return $response;
    }
    function add_package_attributes($package_id) {
        $package_attributes=$this->input->post('category_id');
        $category_id = $this->input->post('category_id');
        $product_id = $this->input->post('product_id');
        $product_type = $this->input->post('product_type');
        $product_min_people = $this->input->post('product_min_people');
        $product_price = $this->input->post('product_price');
        $group_number = $this->input->post('group_number');
        $group_count = $this->input->post('group_count');
        $is_upgradable = $this->input->post('is_upgradable');
        $status = $this->input->post('status');
        foreach ($package_attributes as $key => $package_attribute) {
            $this->db->set('pkg_attr_package_fk', $package_id);            
            $this->db->set('pkg_attr_cat_fk', $category_id[$key]);
            $this->db->set('pkg_attr_prd_fk', $product_id[$key]);
            $this->db->set('pkg_attr_type', $product_type[$key]);
            $this->db->set('pkg_attr_min_people', $product_min_people[$key]);
            $this->db->set('pkg_attr_price', $product_price[$key]);
            $this->db->set('pkg_attr_upgradable', $is_upgradable[$key]);
            $this->db->set('pkg_attr_group_no', $group_number[$key]);
            $this->db->set('pkg_attr_group_count', $group_count[$key]);
            $this->db->set('pkg_attr_status', $status[$key]);           
            $query = $this->db->insert($this->package_attributes_table);
            $response = $this->db->insert_id();
        }
        return $response;
    }

    function get_package_attributes($package_id) {
        $this->db->where('pkg_attr_package_fk', $package_id);
        $this->db->where($this->package_attributes_table . '.pkg_attr_status !=', 'deleted');
        $query = $this->db->get($this->package_attributes_table);
        $result = $query->result();
        return $result;
    }

    public function delete_package_attribute($package_attribute_id) {
        $this->db->set('pkg_attr_status', 'deleted');
        $this->db->where('pkg_attr_id', $package_attribute_id);
        $response = $this->db->update($this->package_attributes_table);
        return $response;
    }
    public function delete_package_attributes($package_id) {
        $this->db->where('pkg_attr_package_fk', $package_id);
        $response = $this->db->delete($this->package_attributes_table);
        return $response;
    }

}
