<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Product_Label_Model extends CI_Model {

    var $product_label_table = 'tbl_product_labels';

    function get_product_label_list() {
        $this->db->select('*');
        $this->db->from($this->product_label_table);
        $this->db->where($this->product_label_table . '.prd_label_status !=', 'deleted');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    function get_product_label_detail($product_label_id) {
        $this->db->select('*');
        $this->db->from($this->product_label_table);
        $this->db->where($this->product_label_table . '.prd_label_status !=', 'deleted');
        $this->db->where($this->product_label_table . '.prd_label_id', $product_label_id);
        $query = $this->db->get();
        $result = $query->row_array();
        return $result;
    }

    function add_product_label($product_label_image) {
        if ($product_label_image)
            $this->db->set('prd_label_image', $product_label_image);
        $this->db->set('prd_label_name', $this->input->post('prd_label_name'));
        $this->db->set('prd_label_status', 'active');
        return $this->db->insert($this->product_label_table);
    }

    function update_product_label($product_label_id, $product_label_image) {
        if ($product_label_image)
            $this->db->set('prd_label_image', $product_label_image);
        $this->db->set('prd_label_name', $this->input->post('prd_label_name'));
        $this->db->where('prd_label_id', $product_label_id);
        return $this->db->update($this->product_label_table);
    }

    public function update_status($product_label_id, $product_label_status) {
        $this->db->set('prd_label_status', $product_label_status);
        $this->db->where('prd_label_id', $product_label_id);
        $response = $this->db->update($this->product_label_table);
        return $response;
    }
}
