<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class blog_model extends CI_Model {

    var $blog_table = 'tbl_blog';
    var $blog_category_table = 'tbl_blog_category';
    var $blog_comment_table = 'tbl_blog_comments';

    function get_blogs() {
        $this->db->where($this->blog_table . '.blog_status', 'active');
        $query = $this->db->get($this->blog_table);
        $result = $query->result_array();
        return $result;
    }

    public function get_blogs_by_category_id($blog_cat_id) {
        $this->db->select('*');
        $this->db->where($this->blog_table . '.blog_cat_fk', $blog_cat_id);
        $this->db->join($this->blog_category_table, $this->blog_table . '.blog_cat_fk=' . $this->blog_category_table . '.blog_cat_id');
        $this->db->where($this->blog_table . '.blog_status', 'active');
        $query = $this->db->get($this->blog_table);
        $result = $query->result_array();
        return $result;
    }

    function get_blog_categories() {
        $this->db->where($this->blog_category_table . '.blog_cat_status', 'active');
        $query = $this->db->get($this->blog_category_table);
        $result = $query->result_array();
        return $result;
    }

    public function create_blog_comment($blog_id) {
        $this->db->set('blog_commenter_blog_fk', $blog_id);
        $this->db->set('blog_commenter_name', $this->input->post('commenter_name'));
        $this->db->set('blog_commenter_email', $this->input->post('commenter_email'));
        $this->db->set('blog_commenter_phone', $this->input->post('commenter_phone'));
        $this->db->set('blog_commenter_subject', $this->input->post('commenter_subject'));
        $this->db->set('blog_commenter_comment', $this->input->post('commenter_comment'));
        $this->db->set('blog_commenter_status', 'unread');
        $this->db->set('blog_commenter_ip', $this->input->ip_address());
        $this->db->set('blog_commenter_time', time());
        $query = $this->db->insert($this->blog_comment_table);
        $response = $this->db->insert_id();
        return $response;
    }

    public function get_recent_blogs() {
        $this->db->from($this->blog_table);
        $this->db->where($this->blog_table . '.blog_status', 'active');
        $this->db->order_by($this->blog_table . '.blog_id', 'desc');
        $this->db->limit(4);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    public function get_blog_detail($blog_slug = FALSE) {
        $this->db->where($this->blog_table . '.blog_slug', $blog_slug);
        $this->db->where($this->blog_table . '.blog_status', 'active');
        $query = $this->db->get($this->blog_table);
        $result = $query->row_array();
        return $result;
    }

    public function get_comments_by_blog($blog_id) {
        $this->db->where('blog_commenter_blog_fk', $blog_id);
        $this->db->where($this->blog_comment_table . '.blog_commenter_status', 'active');
        $this->db->order_by($this->blog_comment_table . '.blog_commenter_time', 'desc');
        $query = $this->db->get($this->blog_comment_table);
        $result = $query->result_array();
        return $result;
    }

    public function blog_counts_by_category($blog_cat_id) {
        $this->db->where($this->blog_table . '.blog_cat_fk', $blog_cat_id);
        $this->db->where($this->blog_table . '.blog_status', 'active');
        $query = $this->db->get($this->blog_table);
        $result = $query->num_rows();
        return $result;
    }

    public function getBlogs($add_time) {
        $this->db->select('*,' . $this->blog_table . '.add_time, YEAR(FROM_UNIXTIME(' . $this->blog_table . '.add_time))');
        $this->db->where('YEAR(FROM_UNIXTIME(' . $this->blog_table . '.add_time))', $add_time);
        $this->db->where($this->blog_table . '.status', 'active');
        $query = $this->db->get($this->blog_table);
        $result = $query->result_array();
        return $result;
    }

    public function getBlogArchives($add_time) {
        $this->db->select('*,' . $this->blog_table . '.add_time, YEAR(FROM_UNIXTIME(' . $this->blog_table . '.add_time))');
        $this->db->where('YEAR(FROM_UNIXTIME(' . $this->blog_table . '.add_time))', $add_time);
        $this->db->where($this->blog_table . '.status', 'active');
        $query = $this->db->get($this->blog_table);
        $result = $query->result_array();
        return $result;
    }

    public function getBlogArchive() {
        $this->db->select('*,tbl_blog.add_time,MONTH(FROM_UNIXTIME(tbl_blog.add_time)), YEAR(FROM_UNIXTIME(tbl_blog.add_time))');
        $this->db->from('tbl_blog');
        $this->db->where('tbl_blog.status', 'active');
        $this->db->group_by('YEAR(FROM_UNIXTIME(tbl_blog.add_time))');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    public function countArchiveByTime($add_time) {
        $this->db->select('*,' . $this->blog_table . '.add_time, YEAR(FROM_UNIXTIME(' . $this->blog_table . '.add_time))');
        $this->db->where('YEAR(FROM_UNIXTIME(' . $this->blog_table . '.add_time))', $add_time);
        $this->db->where($this->blog_table . '.blog_status', 'active');
        $query = $this->db->get($this->blog_table);
        $result = $query->num_rows();
        return $result;
    }

}
