<?php

class Category_Model extends CI_Model {

    var $category_table = 'tbl_category';
    var $products_table = 'tbl_products';
    var $products_labels_table = 'tbl_product_labels';
    var $products_attributes_table = 'tbl_product_attributes';
    var $attributes_table = 'tbl_attributes';

    function get_categories_by_type($cat_type_id = FALSE, $cat_parent_id = FALSE) {
        $this->db->where($this->category_table . '.cat_status', 'active');
        if ($this->config->item('website_multi_location') == 'yes')
            $this->db->where($this->category_table . '.cat_loc_fk', $this->session->userdata('user_location_id'));
        if ($cat_type_id !== FALSE)
            $this->db->where($this->category_table . '.cat_type_fk', $cat_type_id);
        if ($cat_parent_id !== FALSE)
            $this->db->where($this->category_table . '.cat_parent_fk', $cat_parent_id);
        $query = $this->db->get($this->category_table);
        $result = $query->result_array();
        return $result;
    }

    function get_products_by_category($prd_cat_id = FALSE) {
        $this->db->where($this->products_table . '.prd_status', 'active');
        if ($prd_cat_id !== FALSE)
            $this->db->where($this->products_table . '.prd_cat_fk', $prd_cat_id);
        $query = $this->db->get($this->products_table);
        $result = $query->result_array();
        return $result;
    }

    function get_product_attributes($prd_id = FALSE) {
        $this->db->select('*');
        $this->db->where($this->products_attributes_table . '.prd_attr_prd_fk', $prd_id);
        $this->db->where($this->products_attributes_table . '.prd_attr_status', 'active');
        $this->db->join($this->attributes_table, $this->products_attributes_table . '.prd_attr_attr_fk=' . $this->attributes_table . '.attr_id');
        $this->db->where($this->attributes_table . '.attr_status', 'active');
        $query = $this->db->get($this->products_attributes_table);
        $result = $query->result_array();
        return $result;
    }

    function get_category_detail($cat_slug = FALSE, $cat_id = FALSE, $cat_type_id = FALSE) {
        if ($this->config->item('website_multi_location') == 'yes')
            $this->db->where($this->category_table . '.cat_loc_fk', $this->session->userdata('user_location_id'));
        if ($cat_id)
            $this->db->where($this->category_table . '.cat_id', $cat_id);
        if ($cat_slug)
            $this->db->where($this->category_table . '.cat_slug', $cat_slug);
        if ($cat_type_id)
            $this->db->where($this->category_table . '.cat_type_fk', $cat_type_id);
        $this->db->where($this->category_table . '.cat_status', 'active');
        $query = $this->db->get($this->category_table);
        $result = $query->row_array();
        return $result;
    }

    function get_product_detail($prd_id, $prd_attr_id = FALSE, $cat_type_id = FALSE) {
        $this->db->select('*');
        $this->db->join($this->products_attributes_table, $this->products_attributes_table . '.prd_attr_prd_fk=' . $this->products_table . '.prd_id');
        $this->db->join($this->attributes_table, $this->products_attributes_table . '.prd_attr_attr_fk=' . $this->attributes_table . '.attr_id');
        $this->db->join($this->category_table, $this->category_table . '.cat_id=' . $this->products_table . '.prd_cat_fk');
        if ($this->config->item('website_multi_location') == 'yes')
            $this->db->where($this->category_table . '.cat_loc_fk', $this->session->userdata('user_location_id'));
        if ($cat_type_id)
            $this->db->where($this->category_table . '.cat_type_fk', $cat_type_id);
        $this->db->where($this->attributes_table . '.attr_status', 'active');
        $this->db->where($this->products_attributes_table . '.prd_attr_status', 'active');
        $this->db->where($this->category_table . '.cat_status', 'active');
        $this->db->where($this->products_table . '.prd_status', 'active');
        $this->db->where($this->products_table . '.prd_id', $prd_id);
        $this->db->where($this->products_attributes_table . '.prd_attr_prd_fk', $prd_id);
        $this->db->where($this->products_attributes_table . '.prd_attr_id', $prd_attr_id);
        $query = $this->db->get($this->products_table);
        $result = $query->row_array();
        return $result;
    }

    function get_product_label_detail($prd_label_id) {
        $this->db->where($this->products_labels_table.'.prd_label_status', 'active');
        $this->db->where($this->products_labels_table.'.prd_label_id', $prd_label_id);
        $query = $this->db->get($this->products_labels_table);
        $result = $query->row_array();
        return $result;
    }

}
