<?php

class Locations_Model extends CI_Model {

    var $locations_table = 'tbl_locations';
    var $locations_type_table = 'tbl_location_type';
    var $locations_images_table = 'tbl_location_images';

    function get_locations_list($location_type_id=FALSE,$location_for_site=TRUE) {
        $this->db->select('*');
        $this->db->where($this->locations_table . '.loc_status', 'active');
        $this->db->join($this->locations_type_table, $this->locations_table . '.loc_type_fk=' . $this->locations_type_table . '.loc_type_id');
        if($location_for_site)
        $this->db->where($this->locations_type_table . '.loc_for_site', 'yes');
        if($location_type_id)
        $this->db->where($this->locations_table . '.loc_type_fk', $location_type_id);
        $this->db->where($this->locations_type_table . '.loc_type_status', 'active');
        $query = $this->db->get($this->locations_table);
        $result = $query->result_array();
        return $result;
    }

    function get_location_detail($loc_slug=FALSE,$loc_id=FALSE,$loc_for_site='yes') {
        $this->db->select('*');
        if($loc_slug)
        $this->db->where($this->locations_table . '.loc_slug', $loc_slug);
        if($loc_id)
             $this->db->where($this->locations_table . '.loc_id', $loc_id);
        $this->db->where($this->locations_table . '.loc_status', 'active');
        $this->db->join($this->locations_type_table, $this->locations_table . '.loc_type_fk=' . $this->locations_type_table . '.loc_type_id');
        if($loc_for_site)
        $this->db->where($this->locations_type_table . '.loc_for_site',$loc_for_site);
        $this->db->where($this->locations_type_table . '.loc_type_status', 'active');
        $query = $this->db->get($this->locations_table);
        $result = $query->row_array();
        return $result;
    }

    function get_location_gallery($loc_id) {
        $this->db->select('*');
        $this->db->where($this->locations_images_table . '.loc_img_loc_fk', $loc_id);
        $this->db->where($this->locations_images_table . '.loc_img_status', 'active');
        $query = $this->db->get($this->locations_images_table);
        $result = $query->result_array();
        return $result;
    }
    function get_location_default_image($loc_id) {
        $this->db->select('*');
        $this->db->where($this->locations_images_table . '.loc_img_loc_fk', $loc_id);
        $this->db->where($this->locations_images_table . '.loc_img_status', 'active');
        $this->db->where($this->locations_images_table . '.loc_img_default', 'yes');
        $this->db->order_by('loc_img_id', 'RANDOM');
        $query = $this->db->get($this->locations_images_table);
        $result = $query->row_array();
        return $result;
    }
    function getProvinceById($loc_id){
        $this->db->select('*');
        $this->db->where($this->locations_table . '.loc_id', $loc_id);
        $this->db->where($this->locations_table . '.loc_status', 'active');
        $query = $this->db->get($this->locations_table);
        $result = $query->row_array();
        return $result;
    }
}
