<script type="text/javascript" src="<?php echo $this->config->item('ckeditor_basepath'); ?>ckeditor.js"></script>
<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $breadcumb ?><small ><?php echo $breadcumb ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $breadcumb ?>                  
                </li>               
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject font-green-sharp bold uppercase"><a href="<?= site_url($this->config->item('backend_url') . '/category/' . $cat_type_id) ?>">Back</a></span>
                        </div>                         
                    </div>
                    <div class="portlet-body form">
                        <form class="form-horizontal" role="form" method="post" enctype="multipart/form-data">
                            <div class="form-body">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Category Title</label>
                                    <div class="col-md-9">
                                        <input type="text" name="cat_name" value="<?= $cat_name ?>" class="form-control" placeholder="Enter Category Name">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('cat_name')) ?></p>
                                    </div>
                                </div>
                                <?php if ($this->config->item('website_multi_location') == 'yes') {
                                    $this->load->view($this->config->item('backend_folder_name') . '/location_dropdown_div');
                                } ?>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Category Content</label>
                                    <div class="col-md-9">
                                        <textarea class="form-control ckeditor" name="cat_content" rows="3"><?= $cat_content ?></textarea>
                                    </div>
                                </div>  
                                <div class="form-group">
                                    <label for="exampleInputFile" class="col-md-3 control-label">Category Image</label>
                                    <div class="col-md-9">
                                        <input type="file" onChange="readURL(this);" id="cat_image" name="cat_image" value="<?= $cat_image ?>"><br>
                                        <?php if (isset($cat_image) && $cat_image != '') { ?>
                                            <img id="cat_image_preview" src="<?= $this->config->item('uploads'); ?>category_images/<?= $cat_image ?>" width="50px" height="50px">
                                        <?php } else { ?>
                                            <img id="cat_image_preview" src="<?= $this->config->item('backend_assets'); ?>layout/img/upload_image.png" width="50px" height="50px">
                                        <?php } ?>                            
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('cat_image')) ?></p>

                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Category Meta Title</label>
                                    <div class="col-md-9">
                                        <input type="text" name="cat_title" value="<?= $cat_title ?>" class="form-control" placeholder="Enter Category Meta Title"> 
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Category Keywords</label>
                                    <div class="col-md-9">
                                        <input type="text" name="cat_keywords" value="<?= $cat_keywords ?>" class="form-control" placeholder="Enter Category Keywords"> 
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Category Description</label>
                                    <div class="col-md-9">
                                        <textarea class="form-control" name="cat_description" rows="3"><?= $cat_description ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="form-actions">
                                <div class="row">
                                    <div class="col-md-offset-3 col-md-9">
                                        <button type="submit" class="btn green">Submit</button>
                                        <button type="reset" class="btn default">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            //alert(input.id);
            reader.onload = function (e) {
                $('#' + input.id + '_preview').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

</script>
<script type="text/javascript">
    CKEDITOR.replace('editor',
            {
                filebrowserBrowseUrl: '<?php echo $this->config->item('ckeditor_basepath'); ?>ckfinder/ckfinder.html',
                filebrowserImageBrowseUrl: '<?php echo $this->config->item('ckeditor_basepath'); ?>ckfinder/ckfinder.html?type=Images',
                filebrowserFlashBrowseUrl: '<?php echo $this->config->item('ckeditor_basepath'); ?>ckfinder/ckfinder.html?type=Flash'
            });
</script> 