<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $page_heading ?><small> <?php echo $page_heading ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $page_heading ?>                   
                </li>             
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-globe"></i><?php echo $page_heading ?>       
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-toolbar">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="btn-group">
                                        <a href="<?= site_url($this->config->item('backend_url') . '/location/add/' . $location_type_id) ?>" class="btn green" id="sample_editable_1_new">
                                            Add New <i class="fa fa-plus"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <table class="table table-striped table-bordered table-hover" id="sample_6">
                            <thead>
                                <tr>
                                    <th>Location Name</th>        
                                    <th>Status</th>
                                    <th>Action</th>   
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($location_data as $location) {
                                    $loc_type_name = $this->common_model->get_single_field_from_any_table('loc_type_name', 'loc_type_id', $location['loc_type_fk'], 'tbl_location_type');
                                    ?>
                                    <tr class="odd gradeX">                                       
                                        <td><?php echo (isset($location['loc_name'])) ? $location['loc_name'] : '-'; ?></td>
                                        <td>
                                            <?php if ($location['loc_status'] == 'active') { ?>
                                                <span class="label label-sm label-success">Active</span> 
                                            <?php } else if ($location['loc_status'] == 'inactive') { ?>
                                                <span class="label label-sm label-warning">Inactive</span>
                                            <?php } ?>
                                        </td>                                                                          
                                        <td>
                                            <div class="col-md-6">
                                                <div class="btn-group">
                                                    <button class="btn btn-success dropdown-toggle" data-toggle="dropdown">Action <i class="fa fa-angle-down"></i>
                                                    </button>
                                                    <ul class="dropdown-menu pull-right">
                                                        <li>
                                                            <a href="<?= site_url($this->config->item('backend_url') . '/location/edit/' . $location['loc_type_fk'] . '/' . $location['loc_id']) ?>">
                                                                Edit </a>
                                                        </li>
                                                        <?php if ($location['loc_status'] == 'active') { ?>
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/inactivate-location/' . $location['loc_id']) ?>">Inactivate</a>
                                                            </li>
                                                        <?php } else if ($location['loc_status'] == 'inactive') { ?>
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/activate-location/' . $location['loc_id']) ?>">Activate </a>
                                                            </li>
                                                        <?php } ?>
                                                        <li>
                                                            <a href="<?= site_url($this->config->item('backend_url') . '/delete-location/' . $location['loc_id']) ?>">Delete </a>
                                                        </li>
                                                        <?php
                                                        if ($location['loc_for_site'] == 'yes') {
                                                            ?>
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/location/images/' . $location['loc_id']) ?>">
                                                                    Manage Images 
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/location/detail/' . $location_type_id . '/' . $location['loc_id']) ?>">
                                                                    Location Details
                                                                </a>
                                                            </li>
                                                        <?php } ?>
                                                    </ul>
                                                </div>
                                            </div>   
                                        </td>                                                             
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
