<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $page_heading ?><small> <?php echo $page_heading ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $page_heading ?>                            
                </li>             
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-globe"></i><?php echo $page_heading ?>                  
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-toolbar">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="btn-group">
                                        <a href="<?= site_url($this->config->item('backend_url') . '/meta-tag/add') ?>" class="btn green">
                                            Add New <i class="fa fa-plus"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <table class="table table-striped table-bordered table-hover" id="sample_6">
                            <thead>
                                <tr>
                                    <th>Meta Tag URL</th>                             
                                    <th>Meta Tag Title</th>                             
                                    <th>Meta Tag Keywords</th>                             
                                    <th>Meta Tag Description</th>                             
                                    <th>Meta Tag Image</th>        
                                    <th>Status</th>
                                    <th>Action</th>   
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($meta_tags as $meta_tag) {
                                    ?>
                                    <tr class="odd gradeX">                                       
                                        <td><?php echo (isset($meta_tag['meta_tag_url'])) ? $meta_tag['meta_tag_url'] : '-'; ?></td>                              
                                        <td><?php echo (isset($meta_tag['meta_tag_title'])) ? $meta_tag['meta_tag_title'] : '-'; ?></td>                              
                                        <td><?php echo (isset($meta_tag['meta_tag_keywords'])) ? $meta_tag['meta_tag_keywords'] : '-'; ?></td>                              
                                        <td><?php echo (isset($meta_tag['meta_tag_description'])) ? $meta_tag['meta_tag_description'] : '-'; ?></td>                              
                                        <td><img src="<?= $this->config->item('uploads') ?>header_images/<?php echo $meta_tag['meta_tag_image'] ?>" width="50px" height="50px"></td>
                                        <td>
                                            <?php if ($meta_tag['meta_tag_status'] == 'active') { ?>
                                                <span class="label label-sm label-success">Active</span> 
                                            <?php } else if ($meta_tag['meta_tag_status'] == 'inactive') { ?>
                                                <span class="label label-sm label-warning">Inactive</span>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <div class="col-md-6">
                                                <div class="btn-group">
                                                    <button class="btn btn-success dropdown-toggle" data-toggle="dropdown">Action <i class="fa fa-angle-down"></i>
                                                    </button>
                                                    <ul class="dropdown-menu pull-right">
                                                        <li>
                                                            <a href="<?= site_url($this->config->item('backend_url') . '/meta-tag/edit/'.$meta_tag['meta_tag_id']) ?>">Edit</a>
                                                        </li>
                                                        <?php if ($meta_tag['meta_tag_status'] == 'active') { ?>
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/inactivate-meta-tag/' . $meta_tag['meta_tag_id']) ?>">Inactivate</a>
                                                            </li>
                                                        <?php } else if ($meta_tag['meta_tag_status'] == 'inactive') { ?>
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/activate-meta-tag/' . $meta_tag['meta_tag_id']) ?>">Activate </a>
                                                            </li>
                                                        <?php } ?>
                                                        <li>
                                                            <a href="<?= site_url($this->config->item('backend_url') . '/delete-meta-tag/' . $meta_tag['meta_tag_id']) ?>">Delete </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>   
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>