<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $page_heading ?><small> <?php echo $page_heading ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $page_heading ?>                   
                </li>             
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-globe"></i> <?php echo $page_heading ?>            
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="sample_6">
                            <thead>
                                <tr>
                                    <th>Order Id</th>                                
                                    <th>Name</th>     
                                    <th>Email</th>     
                                    <th>Phone</th>     
                                    <th>Order Type</th>     
                                    <th>Payment Type</th>     
                                    <th>Status</th>
                                    <th>Action</th>   
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($orders_list as $order) {
                                    ?>
                                    <tr class="odd gradeX">                                       
                                        <td><?php echo (isset($order['order_id'])) ? 'SI-'.$order['order_id'] : '-'; ?></td> 
                                        <td><?php echo (isset($order['order_cus_name'])) ? $order['order_cus_name'] : '-'; ?></td> 
                                        <td><?php echo (isset($order['order_cus_email'])) ? $order['order_cus_email'] : '-'; ?></td> 
                                        <td><?php echo (isset($order['order_cus_phone'])) ? $order['order_cus_phone'] : '-'; ?></td> 
                                        <td><?php echo (isset($order['order_type'])) ? $order['order_type'] : '-'; ?></td> 
                                        <td><?php echo (isset($order['order_pay_type'])) ? $order['order_pay_type'] : '-'; ?></td>
                                        <td>
                                            <span class="label label-sm label-success"><?= strtoupper($order['order_status']) ?></span>
                                        </td>
                                        <td>
                                            <div class="col-md-6">
                                                <div class="btn-group">
                                                    <button class="btn btn-success dropdown-toggle" data-toggle="dropdown">Action <i class="fa fa-angle-down"></i></button>
                                                    <ul class="dropdown-menu pull-right">                                                
                                                        <li>
                                                            <a href="<?= site_url() . $this->config->item('backend_url') . '/order/'.$order['order_id'] ?>">View</a>
                                                        </li>
                                                        <li>
                                                            <a href="<?= site_url() . $this->config->item('backend_url') . '/order/update-tracking-message/'.$order['order_id'] ?>">Update Tracking Message</a>
                                                        </li>
                                                        <li>
                                                            <a href="<?= site_url() . $this->config->item('backend_url') . '/delete-order/'.$order['order_id'] ?>">Delete</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>   
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>