<aside class="sidebar_cart">
    <?php
    $cart_data = $this->cart->get_cart_detail();
    $cart_products_data = $this->cart->get_cart_products();
    ?>
    <h4 class="section_title">Your order <span class="fa fa-shopping-cart"><span class="badge"><?= count($cart_products_data); ?></span></span></h4>
    <div class="loader">
        <i class="fa fa-spinner fa-spin"></i>
        <ol>
            <?php
            if ($cart_products_data) {
                foreach ($cart_products_data as $cart_product) {
                    ?>
                    <li>
                        <h4>
                            <span>
                                <?php echo $cart_product['cart_prd_quantity'] ?>
                            </span>
                            <?php echo ($cart_product['cart_prd_unit']) ? $cart_product['cart_prd_unit'] : (($cart_product['cart_prd_people']) ? $cart_product['cart_prd_people'] . ' People' : ''); ?>&nbsp;<?php echo $cart_product['cart_prd_name'] ?>
                        </h4>
                        <div class="btn-group">
                            <a href="javascript:;" data-prd-id="<?= $cart_product['cart_prd_id'] ?>" data-prd-qty="<?= $cart_product['cart_prd_quantity'] - 1 ?>" class="btn btn-default btn-sm update_prd_qty">-</a>
                            <a href="javascript:;" data-prd-id="<?= $cart_product['cart_prd_id'] ?>" data-prd-qty="<?= $cart_product['cart_prd_quantity'] + 1 ?>" class="btn btn-default btn-sm update_prd_qty">+</a>
                            <a href="javascript:;" data-prd-id="<?= $cart_product['cart_prd_id'] ?>" data-prd-qty="0" class="btn btn-default btn-sm update_prd_qty"><i class="fa fa-trash-o"></i></a>
                            <?php if ($cart_product['cart_prd_type'] == 'package') { ?>
                                <a href="<?= site_url('cart-package-products/' . $cart_product['cart_prd_id']) ?>" class="fancybox fancybox.iframe btn btn-default btn-sm" ><i class="fa fa-eye"></i></a>
                            <?php } ?>
                        </div>
                        <span class="order_price">$ <?php echo number_format($cart_product['cart_prd_tot_price'], 2, '.', '') ?></span>
                    </li>
                <?php } ?>
            </ol>
            <table class="table table-bordered">
                <tbody>
                    <tr>
                        <td>Subtotal</td>
                        <td align="right">$ <?php echo number_format($cart_data['cart_prd_total'], 2, '.', '') ?></td>
                    </tr>
                    <?php if ($cart_data['cart_cpn_discount']) { ?>
                        <tr>
                            <td>Discount <?= ($cart_data['cart_cpn_per']) ? '( ' . number_format($cart_data['cart_cpn_per'], 2, '.', ',') . '%)' : '' ?></td>
                            <td align="right">$ <?php echo number_format($cart_data['cart_cpn_discount'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>  
                    <?php if ($cart_data['cart_gst'] && $cart_data['cart_gst_per']) { ?>
                        <tr>
                            <td>GST (<?= $cart_data['cart_gst_per'] ?>%)</td>
                            <td align="right">$ <?php echo number_format($cart_data['cart_gst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($cart_data['cart_pst'] && $cart_data['cart_pst_per']) { ?>
                        <tr>
                            <td>PST (<?= $cart_data['cart_pst_per'] ?>%)</td>
                            <td align="right">$ <?php echo number_format($cart_data['cart_pst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($cart_data['cart_hst'] && $cart_data['cart_hst_per']) { ?>
                        <tr>
                            <td>HST (<?= $cart_data['cart_hst_per'] ?>%)</td>
                            <td align="right">$ <?php echo number_format($cart_data['cart_hst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($cart_data['cart_del_charges']) { ?>
                        <tr>
                            <td>Delivery Charges (<?= $cart_data['cart_del_loc_name'] ?>)</td>
                            <td align="right">$ <?php echo number_format($cart_data['cart_del_charges'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td>Total</td>
                        <td align="right">$ <?php echo number_format($cart_data['cart_total'], 2, '.', '') ?></td>
                    </tr>
                </tbody>
            </table>
        <?php } else {
            ?>
            <ol>
                <li>
                    Cart is empty Right Now.
                </li>
            </ol>
        <?php } ?>
    </div>
    <?php if ($this->uri->segment(1) == 'checkout') { ?>
        <a href="<?= site_url('online-order') ?>" class="btn btn-primary">Continue Shopping</a>
    <?php } else { ?>
        <?php if ($cart_product_data && $cart_data) { ?>
            <form role="form" class="coupon_form" method="post" action="<?= site_url('apply-cart-coupon') ?>">
                <div class="input-group">
                    <input type="text" class="form-control" required placeholder="Coupon Code" name='coupon_code'>
                    <span class="input-group-btn">
                        <input type='submit' class="btn btn-primary" name='apply_coupon' value='apply'>
                    </span>
                </div>
            </form>
        <?php } ?>
        <a href="<?= site_url('empty-cart') ?>" class="btn btn-primary">Empty Cart</a>
        <a href="<?= site_url('checkout') ?>" class="btn btn-primary">Checkout</a>
    <?php } ?>
    <hr class="clearfix">
    <?php
    $promo_banners = $this->common_model->get_banners(2);
    foreach ($promo_banners as $promo_banner) {
        ?>
        <a href="<?= $promo_banner['bnr_title'] ?>" class="Advertisement"><img src="<?= $this->config->item('uploads') ?>banner_images/<?= $promo_banner['bnr_image'] ?>" alt="<?= $promo_banner['bnr_title'] ?>"></a>
        <?php } ?>
</aside>
